
// author: RuanShengQiang 
// date: 2017/6/21
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define PI 3.141592653589f

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

static vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

static float bar(vec2 uv, float offset, float height)
{
	return  step(offset , uv.y) - step(offset+height, uv.y) ;
}

static float GetParabolaMap(float t, float T)	
{
	return (3.0f * T * t * t - 2.0f * t * t * t) / (T * T);
}

static float GetSinusoidalMap(float t, float T)	
{
	return t - T * sin(2.0f * PI * t / T) / (2.0f * PI);
}

static float line(vec2 p0, vec2 p1, float x)
{
	return ((p1.y - p0.y)/(p1.x - p0.x))*(x - p0.x) + p0.y; 
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	float iPro = GetSinusoidalMap(progress, 1.0f); 	
	iPro = GetParabolaMap(iPro, 1.0f) ;
	float4 y1;
	
	float offset = 1.0f - progress;
	float height  = 0.1f; 
	if(progress<0.62f)
	{
		height = 0.5f*progress;
	}
	else
	{
		height = -0.6609907895f*progress + 0.719814289f;
	}
	float b1 = bar(uv, offset, height);
	
	float b2 = 0;
	const int N = 17;
	if(progress>0.64f)
	{
		for(int i = 0; i<N; i++)
		{
			offset = 1.0 - ( line((vec2)(0.64f,-0.5f*(float)(i)), (vec2)(1.0f,1.0f - (float)(i+1)/(float)(N)), progress));
			height =  line((vec2)(0.64f,0.31f), (vec2)(1.0f,0.058f), progress);
			b2 += bar(uv, offset, height);
		}
	}
	vec4 inColor = INPUT(input1, param, uv);
	vec4 olColor = INPUT(input2, param, uv);
	vec4 outputCol;
	if(b1 + b2 > 0.5f)
		outputCol = olColor;
	else
		outputCol = inColor; 
	write_imagef(dstImg, (int2)(w, textH - h -1), outputCol);
}
